var fs = require('fs');
var express = require('express');
var exphbs = require('express-handlebars');

var STATUS_FILE = 'status.json';
var CONFIG_FILE = process.env.CONFIG_DIR + '/info.json';
var LOG_FILE = '/var/log/express-hello-world.log';

var app = express();
app.use(express.static('public'));
app.engine('handlebars', exphbs());
app.set('view engine', 'handlebars');

//Use the powerful winston module for logging to a file
var winston = require('winston');
winston.add(
  winston.transports.File, { filename: LOG_FILE }
);
winston.info('Starting');

function updateStatusFileWith(message) {
  var status = { pid: process.pid, AppInfo: message };
  winston.info(
    'Updating status file with pid [' + process.pid + '] \ and message [' + message + ']'
  );

  fs.writeFileSync(STATUS_FILE, JSON.stringify(status, null, 2));
}

app.get('/', function (req, res) {
  winston.info('Processing request [GET /]');

  //Render the views/index handlebars template with this data
  res.render('index', {
    layout: false,

    envVars: {
      APP_ID: process.env.APP_ID,
      APP_DIR: process.env.APP_DIR,
      CONFIG_DIR: process.env.CONFIG_DIR
    },
    statusFileContents: fs.readFileSync(STATUS_FILE, 'utf8'),
    configFileContents: fs.readFileSync(CONFIG_FILE, 'utf8'),
    logFilePath: LOG_FILE
  });
  updateStatusFileWith('Last viewed at ' + Date());
});

app.listen(3000, function() {
  winston.info('App listening on port 3000');
  updateStatusFileWith('Listening on port 3000 as of ' + Date());
});

